classdef Tool
    %"Tool" object
    %   Tag     = Marker information used to track the tool
    %   F       = Pose of tool frame WRT tag frame
    %   Name    = Character string name for the tool
    % 
    % Copyright (C) Russell H. Taylor 2013
    % For use with CIS I only
    % Do not redistribute without written permission from Russell Taylor

    properties
        Tag         % definition of tracking tag
        F           % pose of tool frame WRT tag frame
        Name        % tool name
    end
    
    methods
        function T = Tool(tag,F,Name)
            if nargin > 0
                T.Tag = tag;
            end
            if nargin > 1
                T.F = F;
            else T.F = Frame.eye();
            end
            if nargin > 2
                T.Name = Name;
            else
                T.Name='';
            end
        end
           
    end
    
end

